<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>

<?php $__env->startSection('extra-meta'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;margin-bottom: 20px">

        <div class="col-12 col-sm-12 col-md-12">
            <h3 class="ml-5"><b><?php echo e(__('messages.RECEVOIR UNE COMMANDE')); ?></b></h3>
            <div class="col-12 col-md-6 float-left">
                <h3>Saisie du BL</h3>
            </div>
            <div class="col-12 col-sm-6 col-md-3 float-left">
                <a href="<?php echo e(route('rec.histo')); ?>" class="btn btn-danger"><i class="fa fa-info"></i><?php echo e(__('messages.Commandes en attente')); ?></a>
            </div>
            <div class="col-12 col-sm-6 col-md-3 float-right">
                <a href="<?php echo e(route('cmde.index')); ?>" class="btn btn-warning"><i class="fa fa-check"></i> <?php echo e(__('messages.Reclamations')); ?></a>
            </div>
        </div>
        <div class="col-md-12 float-left">
            <div class="col-md-8 float-left">
                <h5 class="ml-3"><?php echo e(__('messages.PRODUITS SELECTIONNES')); ?></h5>
            </div>

            <div class="col-md-4 float-right">
                <h5> <?php echo e(__('messages.LES COMMANDES')); ?></h5>
            </div>
        </div>

        <div class="col-md-12 float-left">
            <div class="col-md-7 float-left">
                <div class="contour_div">
                    <div class="contour_table">
                        <table class="table table-striped table-bordered contour_table" id="pdt_rec">
                        <tr class="cart_menu" style="background-color: rgba(202,217,52,0.48)">
                            <td class="description"><?php echo e(__('messages.Produit')); ?></td>
                            <td class="description"><?php echo e(__('messages.Lot')); ?></td>
                            <td class="price"><?php echo e(__('messages.Qte')); ?></td>
                            <td class="price"><?php echo e(__('messages.Unite')); ?></td>
                            <td class="price"><?php echo e(__('messages.Expire')); ?></td>
                            <td colspan="2"></td>
                        </tr>
                        </table>
                    </div>
                    <div class="info-box">
                        <?php echo $__env->make('reception/form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

            <div class="col-md-5 float-right">
                <div class="form-group cool-md-12 float-left">
                    <select name="commande_id" id="commande_id" class="form-control" onchange="actualiser()">
                        <?php $__currentLoopData = $commandes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$commande): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value= "<?php echo $commande; ?>"> <?php echo $commande; ?> </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="info-box">
                    <div class="table-responsive div_style">
                        <table id="pdt_cmde" class="display table table-striped table-bordered data-table">
                            <thead>
                            <tr class="cart_menu" style="background-color: rgba(202,217,52,0.48)">
                                <td class="description"><?php echo e(__('messages.Produit')); ?></td>
                                <td class="price"><?php echo e(__('messages.Qte Cmde')); ?></td>
                                <td class="price"><?php echo e(__('messages.Qte Cmde')); ?></td>
                            </tr>
                            </thead>
                        </table>
                    </div>

                    <!--Ajouter un produit -->
                    <div id="addModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('messages.Ajouter un produit')); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <span class="form_result" id="form_result"></span>
                                    <form method="post" id="add_form" class="form-horizontal">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group">
                                            <table width="100%">
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12">Libelle: </label>
                                                        <input type="text" name="libelle" id="libelle" class="form-control" readonly/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Qte deja livree ')); ?></label>
                                                        <input type="hidden" name="reference" id="reference" class="form-control" readonly/>
                                                        <input type="hidden" name="qte_cmde" id="qte_cmde" class="form-control" readonly/>
                                                        <input type="text" name="qte_liv" id="qte_liv" class="form-control" readonly/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Lot')); ?> </label>
                                                        <input type="text" name="lot" id="lot" class="form-control" value="Neant"/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Quantite recue')); ?>: </label>
                                                        <input type="text" name="qte" id="qte" class="form-control" required="required" value="0"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Prix achat')); ?> </label>
                                                        <input type="text" name="pa" id="pa" class="form-control" required="required" value="0"/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Prix de vente')); ?> </label>
                                                        <input type="text" name="pv" id="pv" class="form-control" required="required"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12"><?php echo e(__('messages.Unite')); ?> </label>
                                                        <input type="text" name="unite" id="unite" class="form-control"/>
                                                    </td>
                                                    <td width="50%">
                                                        <label class="control-label col-md-12" id="dateexpiration"><?php echo e(__('messages.Expire')); ?> </label>
                                                        <input type="date" name="date_expiration" id="date_expiration" class="form-control"/>
                                                    </td>
                                                </tr>
                                            </table>

                                        </div>
                                        <div class="form-group" align="center">
                                            <input type="hidden" name="action" id="action" />
                                            <input type="hidden" name="produit_id" id="produit_id" />
                                            <input type="hidden" name="reception_si_id" id="reception_si_id" />
                                            <input type="hidden" name="produit_reception_id" id="produit_reception_id" />
                                            <input type="hidden" name="hidden_code" id="hidden_code" />
                                            <input type="hidden" name="hidden_commande_id" id="hidden_commande_id" />
                                            <input type="submit" name="action_button" id="action_button" class="btn btn-success" value="<?php echo e(__('messages.Ajouter')); ?>" />
                                            <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Annuler')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--Supprimer le client -->
                    <main id="confirmModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                                </div>
                                <div class="modal-body">
                                    <h5 align="center" style="margin:0;"><?php echo e(__('messages.Retirer ce produit')); ?> ?</h5>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" name="ok_button" id="ok_button" class="btn btn-danger"><?php echo e(__('messages.Oui')); ?></button>
                                    <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Annuler')); ?></button>
                                </div>
                            </div>
                        </div>
                    </main>

                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        function commande() {
            $.ajax({
                url:"rec.commandes",
                dataType:"json",
                success:function(data)
                {
                    $('#commande_id').empty();
                    $('#commande_id').append('<option id="0"  value="0">- <?php echo e(__('messages.Choisir une commande/Date')); ?> -</option>');
                    for (var i = 0; i < data.length; i++) {
                        $('#commande_id').append('<option id=' + data[i].commande_id + ' value=' + data[i].commande_id + '>'+ data[i].code +' - ' + data[i].date_transfert +'</option>');
                    }
                    $('#commande_id').change();
                }
            })
        }

        function magasin() {
            $.ajax({
                url:"rec.magasins",
                dataType:"json",
                success:function(data)
                {
                    $('#magasin_id').empty();
                    $('#magasin_id').append('<option id=0  value=0>- <?php echo e(__('messages.Choisir un magasin')); ?> -</option>');
                    for (var i = 0; i < data.length; i++) {
                        $('#magasin_id').append('<option id=' + data[i].magasin_id + ' value=' + data[i].magasin_id + '>' + data[i].libelle +'</option>');
                    }
                    $('#magasin_id').change();
                }
            })
        }

        function actualiser() {
            code = document.getElementById("code").value;
            commande_id = document.getElementById("commande_id").value;
            console.log(commande_id)
            if (commande_id!=0){
                $('#pdt_cmde').load('rec.pdt_cmde/'+commande_id);
                $('#pdt_rec').load('rec.pdt_rec/'+code+'/'+commande_id);
                $("div.dataTables_filter input").focus();
                document.getElementById("hidden_commande_id").value=commande_id;
                document.getElementById("cmdenum").value=commande_id;
                getreception(commande_id);
            }
        }

        function getreception(id){
            $.ajax({
                url:"rec.getreception/"+id,
                dataType:"json",
                success:function(data)
                {
                    console.log(data);
                    document.getElementById("reception_id").value=data.reception_si_id;
                }
            })
        }

        function actualiser_rec() {
            code = document.getElementById("code").value;
            reception_id = document.getElementById("reception_id").value;
            if (reception_id!=0){
                $('#pdt_cmde').load('rec.pdt_cmde/'+reception);
                $('#pdt_rec').load('rec.pdt_rec/'+code+'/'+commande_id);
                $("div.dataTables_filter input").focus();
                document.getElementById("hidden_commande_id").value=reception;
                document.getElementById("cmdenum").value=reception;
            }
        }

        $(document).ready(function(){
            $('#pdt_cmde').DataTable({
                language: {
                    searchS: "<?php echo e(__('messages.Recherche produit')); ?>"
                }
            });
            commande();
            actualiser();
            magasin();

            $("div.dataTables_filter input").focus();

            $('#add_form').on('submit', function(event){
                event.preventDefault();
                var code = document.getElementById('code').value;
                var commande_id = document.getElementById('commande_id').value;
                $.ajax({
                    url:"<?php echo e(route('rec.add')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        var html = '';
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                                console.log(data.errors)
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                            console.log(data.error)
                        }
                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#add_form')[0].reset();
                            $('#addModal').modal('hide');
                            $('#pdt_rec').load('rec.pdt_rec_af/'+code);
                            console.log(data.success)

                            $("div.dataTables_filter input").val('');
                            $("div.dataTables_filter input").focus();
                        }
                        $('#form_result').html(html);
                    }
                })
            });

            $(document).on('click', '.editer', function(){
                var id = $(this).attr('id');
                var code = document.getElementById('code').value;
                document.getElementById('hidden_code').value = code;

                var commande_id = document.getElementById('commande_id').value;
                document.getElementById('hidden_commande_id').value = commande_id;
                $('#form_result').html('');
                $.ajax({
                    url:"rec.select_edit/"+id,
                    dataType:"json",
                    success:function(data){
                        if(data.produit.type=='Perissable'){
                            document.getElementById('date_expiration').hidden=false;
                            document.getElementById('dateexpiration').hidden=false;
                        }else{
                            document.getElementById('date_expiration').hidden=true;
                            document.getElementById('dateexpiration').hidden=true;
                        }
                        console.log(id,data.produit.produit_reception_id)
                        $('#reference').val(data.produit.reference);
                        $('#libelle').val(data.produit.libelle);
                        $('#produit_id').val(data.produit.produit_id);
                        $('#hidden_code').val(code);
                        $('#produit_reception_id').val(data.produit.produit_reception_id);
                        $('#reception_id').val(data.produit.reception_si_id);
                        $('#lot').val(data.produit.lot);
                        $('#qte').val(data.produit.qte);
                        $('#qte_cmde').val(data.qte_cmde);
                        $('#qte_liv').val(data.qte_liv-data.produit.qte);
                        $('#pa').val(data.produit.pa);
                        $('#pv').val(data.produit.pv);
                        $('#unite').val(data.produit.unite);
                        $('#date_expiration').val(data.produit.date_expiration);
                        $('#action_button').val("<?php echo e(__('messages.Valider')); ?>");
                        $('#addModal').modal('show');
                        setTimeout(function() {$('#lot').focus();}, 200);
                    }
                })
            });

            $(document).on('click', '.select', function(){
                var id = $(this).attr('id');
                var code = document.getElementById('code').value;
                document.getElementById('hidden_code').value = code;

                var commande_id = document.getElementById('commande_id').value;
                document.getElementById('hidden_commande_id').value = commande_id;

                $('#form_result').html('');
                $.ajax({
                    url:"rec.select/"+id,
                    dataType:"json",
                    success:function(data){
                        if(data.produit.type=='Perissable'){
                            document.getElementById('date_expiration').hidden=false;
                            document.getElementById('dateexpiration').hidden=false;
                        }else{
                            document.getElementById('date_expiration').hidden=true;
                            document.getElementById('dateexpiration').hidden=true;
                        }

                        $('#reference').val(data.produit.reference);
                        $('#libelle').val(data.produit.libelle);
                        $('#produit_id').val(data.produit.produit_id);
                        $('#lot').val(data.produit.lot);
                        $('#qte').val(data.produit.qte_transferee-data.qte_liv);
                        $('#qte_cmde').val(data.produit.qte_commandee);
                        $('#qte_liv').val(data.qte_liv);
                        $('#pa').val(data.produit.prix_achat);
                        $('#pv').val(data.produit.prix_vente);
                        $('#unite').val(data.produit.unite_achat);
                        $('#reception_si_id').val(data.produit.reception_si_id);
                        $('#reception_id').val(data.produit.reception_si_id);
                        $('#hidden_commande_id').val(data.produit.commande_id);
                        $('#hidden_code').val(code);
                        $('#produit_reception_id').val("");
                        $('#action_button').val("<?php echo e(__('messages.Ajouter')); ?>");
                        $('#addModal').modal('show');
                        setTimeout(function() {$('#lot').focus();}, 200);
                    }
                })
            });


            $(document).on('click', '.delete', function(){
                id = $(this).attr('id');
                code = document.getElementById('code').value;
                $.ajax({
                    url:"rec.delete/"+id,
                    success:function(data)
                    {
                        setTimeout(function(){
                            $('#confirmModal').modal('hide');
                            $('#liste_client').DataTable().ajax.reload();
                        }, 100);
                        $('#pdt_rec').load('rec.pdt_rec_af/'+code);
                        $("div.dataTables_filter input").focus();
                    }
                })
            });



        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/reception/index.blade.php ENDPATH**/ ?>